//
//  MCStageChangeManager.h
//  MCStageSync
//
//  Created by Brent Gulanowski on 31/10/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import "MCServerChangeManager.h"

#import <MCServerSupport/MCChangeSet.h>


/*!
 
 The inbound workflow is as follows:
 1. Touch-d receives changes from the device. These are downloaded into the "incoming" folder. When downloaded and cleaned, the changeset is moved into the "apply" folder.
 2. Stage-d pickups the changeset in the "apply" folder and applies them to the device db.
 3. Stage-d reconciles the apply changeset and applies the "reconciledExports" to the device db.
 4. Stage-d appends those reconciled exports to the outgoing changes.
 5. Stage-d applies "changesToImport" to PG
 
 
 */
@interface MCStageChangeManager : MCServerChangeManager {

	MCChangeSet *exportedChanges;
	MCChangeSet *reconciledExports;
	MCChangeSet *changesToImport;
    MCChangeSet *importedChanges;
    
    BOOL preserveImportedChanges; // we may want to preserve imported changes for long term debug purposes
}

@property (retain) MCChangeSet *exportedChanges;
@property (retain) MCChangeSet *reconciledExports;
@property (retain) MCChangeSet *changesToImport;
@property (retain) MCChangeSet *importedChanges;

@property BOOL preserveImportedChanges;


- (MCChangeSet *)newAutoreleasedExportChangeSet;

+ (NSString *)changesToBeImportedFolderName;
- (NSString *)changesToBeImportedChangeSetFolder;

- (NSString *)coaleaseChangesToBeImportedFolder;

- (BOOL)coaleaseWorkingFolders:(NSError **)error;


- (void)appendOutgoingChanges:(MCChangeSet *)moreOutgoing;

/*!
 Moves the changesToImport to importedChanges
 */
- (void)didSuccesfullyImportChanges;

/*!
 Makes sure we don't delete change sets by nilling them out. If there are changesToImport, preserves those on disk.
 */
- (void)preserveChangeSetsDueToError;

@end


typedef enum {
	kMCChangeSetRelativeSizeMuchSmaller,
	kMCChangeSetRelativeSizeSmaller,
	kMCChangeSetRelativeSizeSimilar,
	kMCChangeSetRelativeSizeLarger,
	kMCChangeSetRelativeSizeMuchLarger
} MCChangeSetRelativeSize;

@interface MCChangeSet (MCChangeSetSizeComparing)

- (MCChangeSetRelativeSize)sizeRelativeToChangeSet:(MCChangeSet *)otherChangeSet;

@end

